//******************************************
// file 		: SQ7653_8BIT_TMRAx
// version		: V 1.00 2019/12/12
// brief		: 
// note			:
//******************************************
#ifndef _SQ7653_TMRA0_H__
#define _SQ7653_TMRA0_H__


/******************
 * 1st Argument
 * ****************/
/* ---------------------- user-defined macros ------------------------------ */
//For t_mod_sel------
#define set_8bit    			0x00		     	// 8-bit mode
#define output  				0x01		     	// timer 0 and 1 outputs AND together to TA01O  
#define set_16bit  			    0x02		     	// 16-bit mode
#define pre_scale   			0x04		     	// pre-scale mode
#define complementary   		0x05		     	// complementary mode

//For op_mod_sel------
#define timer    				0x00		    	// timer mode
#define event_counter  		    0x01		     	// event counter mode 
#define capture  				0x03	  	     	// capture mode
#define PWM  					0x04		     	// pulse width modulation (PWM) mode
#define pulse_measure 		    0x05		     	// pulse width measurement mode
#define PPG						0x06		     	// programmable pulse generate (PPG) mode

void TMRA00_Timer_Init(void);
void TMRA00_PPG_Init(void);
void TMRA00_PWM_Init(void);
void TMRA00_ECounter_Init(void);

void TMRA0_12BIT_PWM_Init(void);
void TMRA0_16BIT_ECounter_Init(void);
void TMRA0_16BIT_PPG_Init(void);
//====================
void TMRA0_Prescale_PPG_Init(void);
//====================

void TMRA00_SetDuty(uchar duty); 		           
void TMRA00_SetPeriod(uchar period); 	           
void TMRA01_SetDuty(uchar duty); 		           
void TMRA01_SetPeriod(uchar period); 	           
void TMRA0_16BIT_SetDuty(uint duty);
void TMRA0_16BIT_SetPeriod(uint period);
//======================
void TMRA0_SetPrescale(uchar duty); 		       
//======================

void TMRA00_Start(void);
void TMRA01_Start(void);
void TMRA00_Stop(void); 
void TMRA01_Stop(void);

void TMRA00_IntEnable(void);
void TMRA01_IntEnable(void);
void TMRA00_IntDisable(void);
void TMRA01_IntDisable(void);

void __interrupt TMRA00_IRQ(void);
void __interrupt TMRA01_IRQ(void);

void TMRA10_PPG_Init(void);
void TMRA10_Start(void);
void TMRA10_Stop(void);

#endif








